﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VA.TMP.DataModel;
using VA.TMP.Integration.VIMT.Vista.Mappers;
using VA.TMP.Integration.VIMT.Vista.StateObject;
using VIMT.VIAEMRService.Messages;
using VRM.Integration.Servicebus.Core;
using VA.TMP.OptionSets;
using Microsoft.Xrm.Sdk;
using Microsoft.Xrm.Sdk.Query;

namespace VA.TMP.Integration.VIMT.Vista.PipelineSteps.CancelAppointment
{
    class GetFacilitiesStep : FilterBase<CancelAppointmentStateObject>
    {
        public override void Execute(CancelAppointmentStateObject state)
        {
            using (var srv = new Xrm(state.OrganizationServiceProxy))
            {
                //tsa is deprecated.  Need to get the pat/pro cacilities from the respective TMP Sites
                mcs_site patSite = new mcs_site();
                mcs_site proSite = new mcs_site(); 
                
                //patient
                if (state.ServiceAppointment.mcs_relatedsite != null)
                {
                    patSite = srv.mcs_siteSet.FirstOrDefault(pat => pat.Id == state.ServiceAppointment.mcs_relatedsite.Id);
                }
                if ((patSite.Id != null) && (patSite.Id != Guid.Empty))
                {
                    state.PatFacility = srv.mcs_facilitySet.FirstOrDefault(f => f.Id == patSite.mcs_FacilityId.Id);
                }


                //provider
                if (state.ServiceAppointment.mcs_relatedprovidersite != null)
                {
                    proSite = srv.mcs_siteSet.FirstOrDefault(pro => pro.Id == state.ServiceAppointment.mcs_relatedprovidersite.Id);
                }

                if ((proSite.Id != null) && (proSite.Id != Guid.Empty))
                {
                    state.ProFacility = srv.mcs_facilitySet.FirstOrDefault(p=>p.Id==proSite.mcs_FacilityId.Id);
                }

                //replaced old code:
                //var tsa = srv.mcs_servicesSet.FirstOrDefault(t => t.Id == state.ServiceAppointment.mcs_relatedtsa.Id);
                //if (tsa.cvt_PatientFacility != null)
                //    state.PatFacility = srv.mcs_facilitySet.FirstOrDefault(f => f.Id == tsa.cvt_PatientFacility.Id);
                //if (tsa.cvt_ProviderFacility != null)
                //    state.ProFacility = srv.mcs_facilitySet.FirstOrDefault(f => f.Id == tsa.cvt_ProviderFacility.Id);
            }
        }
    }
}
